<?php

function imageresize($image, $maxwidth, $maxheight)
{
    $w = imagesx($image);
    $h = imagesy($image);
    $procw = (float)$maxwidth / (float)$w;
    $proch = (float)$maxheight / (float)$h;
    $proc = min(array($procw, $proch));
    if ($proc > 1) $proc = 1;
    $new_width = (int)($w * $proc);
    $new_height = (int)($h * $proc);
    $new_image = imagecreatetruecolor($new_width, $new_height);
    imagealphablending($new_image, false);
    imagesavealpha($new_image, true);
    $transparent_colors = imagecolorsforindex($image, $transparent_index);
    $transparent_index = imagecolorallocatealpha($new_image, $transparent_colors['red'], $transparent_colors['green'], 
                                                 $transparent_colors['blue'], $transparent_colors['alpha']);
    imagefill($new_image, 0, 0, $transparent_index);
    imagecopyresampled($new_image, $image, $bordersizeh, $bordersizev, 0, 0, $new_width, $new_height, $w, $h);
    return $new_image;
}

    $submit = getuserdata('submit');
    $actiune = getuserdata('actiune');
    $nume_fisier = getuserdata('nume_fisier');
    
    switch ($actiune)
    {
        case 'upload':
            if (isset($_FILES['file']))
            {
                if ($_FILES['file']['error'] == UPLOAD_ERR_OK)
                {
                    $filename = $_FILES['file']['name'];
                    $i = 0;
                    while (file_exists($imagespath.$filename))
                    {
                        $extpos = strrpos($filename, '.');
                        $filename = substr($filename, 0, $extpos).(++$i).strrchr($filename, '.');
                    }
                    move_uploaded_file($_FILES['file']['tmp_name'], $imagespath.$filename);
                    list($w, $h) = getimagesize($imagespath.$filename);
                    $info = getimagesize($imagespath.$filename);
                    switch ($info[2])
                    {
                        case IMAGETYPE_GIF:
                            $sourcelayer = imagecreatefromgif($imagespath.$filename);
                            $dest = imageresize($sourcelayer, 800, 600);
                            imagegif($dest, $imagespath.$filename);
                            break;
                        case IMAGETYPE_JPEG:
                            $sourcelayer = imagecreatefromjpeg($imagespath.$filename);
                            $dest = imageresize($sourcelayer, 800, 600);
                            imagejpeg($dest, $imagespath.$filename);
                            break;
                        case IMAGETYPE_PNG:
                            $sourcelayer = imagecreatefrompng($imagespath.$filename);
                            $dest = imageresize($sourcelayer, 800, 600);
                            imagepng($dest, $imagespath.$filename);
                            break;
                        case IMAGETYPE_WBMP:
                            $sourcelayer = imagecreatefromwbmp($imagespath.$filename);
                            $dest = imageresize($sourcelayer, 800, 600);
                            imagewbmp($dest, $imagespath.$filename);
                            break;
                        case IMAGETYPE_XBM:
                            $sourcelayer = imagecreatefromxbm($imagespath.$filename);
                            $dest = imageresize($sourcelayer, 800, 600);
                            imagexbm($dest, $imagespath.$filename);
                            break;
                        default:
                            echo "Acest tip de fiier nu este suportat.";
                            exit;
                    }
                }    
            }
            break;          
            
        case 'stergere':
            writepagetitle();
            writepagetop();
            writeinfolayer();
            echo "<form action='{$_SERVER['PHP_SELF']}' method='POST'>";
            echo "<input type='hidden' name='pagina' value='$pagina'>";
            echo "<input type='hidden' name='actiune' value='do_stergere'>";
            echo "<input type='hidden' name='nume_fisier' value='$nume_fisier'>";
            echo "<center><table class='formular'>";
            echo "<tr><th>Sigur dorii s tergei imaginea '$nume_fisier'?</th></tr>";
            echo "<tr><td class='butoane'>";
            echo "<input type='submit' name='submit' id='save' value='terge'>";
            echo "<input type='submit' name='submit' id='cancel' value='Anuleaz'>";
            echo "</td></tr></table></center></form>";
            writepagebottom();
            exit;

        case 'do_stergere':
            if ($submit != 'terge')
            {
                header("Location: {$_SERVER['PHP_SELF']}?pagina=$pagina");
                exit;
            }
            unlink($imagespath.$nume_fisier);
            break;
    }

    writepagetitle();
    writepagetop();
    writeinfolayer();
    echo "<span class='articol'>";
    echo "<h1>Imagini</h1>";
    $dir = scandir($imagespath);
    echo "<table><tr><th colspan='2'>Imagine</th></tr>";
    foreach ($dir as $filename)
    {
        if ( (!array_search($filename, $skipped_images)) && (is_file($imagespath.$filename)) )
        {
            echo "<tr><td style='border-bottom: solid 1px black'><img src='{$imagesroot}{$filename}'><br>$filename<br><br></td>";
            echo "<th class='butoane' style='border-bottom: solid 1px black'>";
            echo "<form action='{$_SERVER['PHP_SELF']}' method='POST'>";
            echo "<input type='hidden' name='actiune' value='stergere'>";
            echo "<input type='hidden' name='pagina' value='$pagina'>";
            echo "<input type='hidden' name='nume_fisier' value='$filename'>";
            echo "<input type='submit' name='submit' id='delete' value='terge'>";
            echo "</form></th></tr>";
        }
    }  
    echo "</table>";  
    echo "<form action='{$_SERVER['PHP_SELF']}' method='POST' enctype='multipart/form-data'>";
    echo "<input type='hidden' name='actiune' value='upload'>";
    echo "<input type='hidden' name='pagina' value='$pagina'>";
    echo "Adaug o nou imagine: ";
    echo "<input type='file' name='file' value=''>";
    echo "<input type='submit' name='submit' id='add' style='width: 130px' value='ncarc'>";
    echo "</form></span>";
    writepagebottom();
?>