<?php

    require_once("{$sitepath}autentificare.php");
    require_once("{$sitepath}pagecomponents.php");

    check_connected();
    
    if (!isset($run_from_service))
    {
        $msg_id_aplicatie = getuserdata('msg_id_aplicatie', 0);
        $msg_id_fisier = getuserdata('msg_id_fisier', 0);
        $msg_text = getuserdata('msg_text', '');
        
        $pagina_tabel = getuserdata('pagina_tabel', 1);
        $nrmed = getuserdata('nrmed', 20);
        $filtru = getuserdata('filtru', '');
    }
    
    $qReteta = $connMain->query("
        SELECT
            r.IdReteta,
            c.IdCasCompensare,
            0 AS ProcCAS,
            c.Sublista,
            CONCAT(c.CodBoala, c.CodPNS) AS CodBoalaPNS,
            m.Denumire AS Medicament,
            r.Cantitate,
            c.PretMaximUT,
            c.PretReferinta,
            r.ValoareAmanunt,
            r.ValoareCompensata,
            r.ValoareAmanunt - r.ValoareCompensata AS ValoareDePlata
        FROM retete r
            JOIN cas_compensari c ON c.IdCasCompensare = r.IdCasCompensare
            JOIN cas_medicamente m ON m.Cod = c.Cod 
                AND m.DataInceput <= c.DataInceput
                AND IFNULL(m.DataSfarsit, '9999-12-31') >= IFNULL(c.DataSfarsit, '9999-12-31')
        WHERE r.IdSesiune = '{$_SESSION['saved_session_id']}'
        ");
    echo $connMain->error;
    if ($qReteta->num_rows > 0)
    {
        echo "\n<table class='reteta'>";
        echo "\n    <thead>";
        echo "\n        <tr>";
        echo "\n            <th>Poziţia </th>";
        echo "\n            <th>% Preţ ref.</th>";
        echo "\n            <th>Lista</th>";
        echo "\n            <th>Cod boală/PNS</th>";
        echo "\n            <th>Denumire medicament</th>";
        echo "\n            <th>Cantitate</th>";
        echo "\n            <th>Preţ amănunt/UT</th>";
        echo "\n            <th>Preţ referinţă/UT</th>";
        echo "\n            <th>Valoare amănunt</th>";
        echo "\n            <th>Valoare compensare</th>";
        echo "\n            <th>Valoare de plată</th>";
        echo "\n            <th>&nbsp;</th>";
        echo "\n        </tr>";
        echo "\n    </thead>";
        echo "\n    <tbody>";
        $pozitia = 0;
        $fValoareAmanunt = 0;
        $fValoareCompensata = 0;
        while ($rReteta = $qReteta->fetch_assoc())
        {
            $pozitia++;
            echo "\n        <tr>";
            echo "\n            <td class='number'>$pozitia.</td>";
            echo "\n            <td class='center'>{$rReteta['ProcCAS']}</td>";
            echo "\n            <td class='center'>{$rReteta['Sublista']}</td>";
            echo "\n            <td class='center'>{$rReteta['CodBoalaPNS']}</td>";
            echo "\n            <td>{$rReteta['Medicament']}</td>";
            echo "\n            <td class='center'>{$rReteta['Cantitate']}</td>";
            echo "\n            <td class='number'>".number_format($rReteta['PretMaximUT'], 6, ',', '.')."</td>";
            echo "\n            <td class='number'>".number_format($rReteta['PretReferinta'], 6, ',', '.')."</td>";
            echo "\n            <td class='number'>".number_format($rReteta['ValoareAmanunt'], 2, ',', '.')."</td>";
            echo "\n            <td class='number'>".number_format($rReteta['ValoareCompensata'], 2, ',', '.')."</td>";
            echo "\n            <td class='number'>".number_format($rReteta['ValoareDePlata'], 2, ',', '.')."</td>";
            echo "\n            <td class='butoane'>";
            echo "<a href='#peloc' onclick='stergeMedicament({$rReteta['IdReteta']})' class='btn_sterge'>Şterge</a></td>";
            echo "\n        </tr>";            
            $fValoareAmanunt += $rReteta['ValoareAmanunt'];
            $fValoareCompensata += $rReteta['ValoareCompensata'];
        }
        echo "\n        <tr class='total'>";
        echo "\n            <td colspan='8' class='right'>TOTAL:</td>";
        echo "\n            <td class='number'>".number_format($fValoareAmanunt, 2, ',', '.')."</td>";
        echo "\n            <td class='number'>".number_format($fValoareCompensata, 2, ',', '.')."</td>";
        echo "\n            <td class='number'>".number_format($fValoareAmanunt - $fValoareCompensata, 2, ',', '.')."</td>";
        echo "\n            <td class='butoane'>";
        echo "<a href='#peloc' onclick='stergeReteta()' class='btn_sterge' style='height: 34px'>Şterge tot</a></td>";
        echo "          </tr>";
        echo "\n    </tbody>";
        echo "\n</table>";
    }
    
?>